# cddvault.py - Data handling routines developed by Optibrium for integration of CDD Vault with StarDrop software
# Use of this code is subject to the terms of the StarDrop License Agreement and use, copying or redistribution
# of this file for use by other persons or organisations is prohibited
# Copyright(C) Optibrium Ltd 2016
# stardrop-support@optibrium.com
#

"""Module that supplies the menu definitions for acccessing CDD Vault from StarDrop"""
import cdd

# CustomMenuName = 'CDD Vault'


def get_stardrop_definitions():
    """Get the menu item definitions."""
    definitions = [
        {
            'script_name': 'CDD Vault/Retrieve Data',
            'callback': cdd.run_search
        },
        {
            'script_name': 'CDD Vault/Change Token',
            'callback': cdd.change_token
        }
    ]

    return definitions
